<?php

namespace frontend\controllers;

use Yii;
use common\models\Registrations;
use common\models\RegistrationsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use common\models\User;
use common\models\Influencers;
use \DrewM\MailChimp\MailChimp;

/**
 * RegistrationController implements the CRUD actions for Registrations model.
 */
class RegistrationController extends Controller
{
    public function actions()
    {
        return [
            // ...
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => \yii\filters\AccessControl::className(),
                'only' => ['create', 'update', 'search'],
                'rules' => [
                    // deny all POST requests
                    // [
                    //     'allow' => false,
                    //     'verbs' => ['POST']
                    // ],
                    // allow authenticated users
                    [
                        'actions' => ['create', 'update', 'index', 'search'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                    [
                        'actions' => ['create', 'search'],
                        'allow' => true,
                        'roles' => ['?'],
                    ],
                    // everything else is denied
                ],
            ],
        ];
    }

    /**
     * Lists all Registrations models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RegistrationsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Registrations model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    // public function actionView($id)
    // {
    //     return $this->render('view', [
    //         'model' => $this->findModel($id),
    //     ]);
    // }

    /**
     * Creates a new Registrations model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate($source = null)
    {
        $model = new Registrations();
        $model->scenario = Registrations::SCENARIO_CREATE;

        $post = Yii::$app->request->post();

        $influencer = Influencers::findOne(['name' => $source]);

        if (!isset($influencer)){
            $source = "none";
        }

        if(!empty($post)){
            //print_r($post);exit;
            $load = $model->load($post);

            //check if user exists
            $oldUser = User::findOne(['email' => $post['Registrations']['email']]);
            if(!$oldUser){
                $user = new User();
                $user->username = $post['Registrations']['email'];
                $user->email = $post['Registrations']['email'];
                $user->setPassword($post['Registrations']['password']);
                $user->generateAuthKey();
                if(!$user->save())
                    throw new \yii\web\HttpException(500, 'Error creating user, please contact the administrator.');
                    
            }
            else{
                $user = $oldUser;
            }

            if ($load) {
                $model->user_id = $user->id;
                $model->registration_no = $model->generateUniqueRandomString();
                $model->user_ip = Yii::$app->getRequest()->getUserIP();
                $model->source = $source;
                
                //$model->created_at = time();
                //$model->updated_at = time();
            }

            if($model->save()){
                //send email to user
                Yii::$app
                ->mailer
                ->compose(
                    ['html' => 'registration-html', 'text' => 'registration-text'],
                    ['model' => $model]
                )
                ->setFrom([Yii::$app->params['supportEmail'] => Yii::$app->name])
                ->setTo($user->email)
                //->setCc(['saq1b.zaf4r@gmail.com'])
                ->setBcc(['registration@federalservicedogregistration.org','portal@federalservicedogregistration.org'])
                ->setSubject($model->dog_name.'\'s Registration # = '.$model->registration_no.' (Federal Service Dog Registration)')
                ->send();
                
                // create mailchimp subscription
                $MailChimp = new MailChimp('4c2ad6fa1f62817524b35a290b07cbd9-us12');

                $list_id = '985c43c01c';

                $result = $MailChimp->post("lists/$list_id/members", [
                                'email_address' => $user->email,
                                'merge_fields' => ['FNAME'=>$model->handler_first_name, 'LNAME'=>$model->handler_last_name],
                                'status'        => 'subscribed',
                            ]);

                if($model->type_of_registration == "Service Dog")
                    return $this->redirect('https://shoptopdogproducts.com/pages/service-dog-packages', 301);
                elseif($model->type_of_registration == "Emotional Support Animal")
                    return $this->redirect('https://shoptopdogproducts.com/pages/emotional-support-animal-packages', 301);
                else    
                    return $this->redirect('https://shoptopdogproducts.com/pages/free-tag', 301);
            }
                
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    public function actionTestreg (){
        $MailChimp = new MailChimp('4c2ad6fa1f62817524b35a290b07cbd9-us12');

        $list_id = '985c43c01c';

        $result = $MailChimp->post("lists/$list_id/members", [
                        'email_address' => 'saqib@cicadasys.com',
                        'merge_fields' => ['FNAME'=>'Saqib', 'LNAME'=>'Zafar'],
                        'status'        => 'subscribed',
                    ]);

        print_r($result);
    }

    /**
     * Updates an existing Registrations model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);
        //check if own record
        if(Yii::$app->user->id != $model->user_id)
            throw new \yii\web\HttpException(403, 'You are not allowed to access this record.');

        $model->scenario = Registrations::SCENARIO_UPDATE;

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['index']);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    public function actionSearch($trakid){

        if (($model = Registrations::findOne(['registration_no' => $trakid])) !== null) {
            return $this->render('view', [
                'model' => $model,
            ]);
        }
        
        return $this->render('notfound');
    }

    /**
     * Finds the Registrations model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Registrations the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Registrations::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException(Yii::t('app', 'The requested page does not exist.'));
    }
}
